class Ex5_14
parameter Real r_A[3](each unit="mm")={0,100,0};/*position  of the point A w.rt. O*/
parameter Real r_B[3](each unit="mm")={-75,0,0};/*position  of the point B w.rt. C*/
parameter Real r_AB[3](each unit="mm")={-(250-75),50,0};/*position  of the point A w.rt. B*/

parameter Real w_OA[3](each unit="rad/s")={0,0,-3/7};/*angular velocity of OA*/
parameter Real w_CB[3](each unit="rad/s")={0,0,2};/*angular velocity of CB*/
parameter Real w_AB[3](each unit="rad/s")={0,0,-6/7};/*angular velocity of AB*/

Real a_A[3](each unit="mm/s^2");/*acceleration of A*/
Real a_B[3](each unit="mm/s^2");/*acceleration of B*/
Real a_AB_n[3](each unit="mm/s^2");/*normal component of acceleration of AB*/
Real a_AB_t[3](each unit="mm/s^2");/*tangential component of acceleration of AB*/

parameter Real alpha_CB[3](each unit="rad/s^2")={0,0,0};/*angular acceleration of CB*/

Real alpha_OA_mag(unit="rad/s^2");/*magnitude of angular acceleration of OA*/
Real alpha_OA[3](each unit="rad/s^2");/*angular acceleration of OA*/

Real alpha_AB_mag(unit="rad/s^2");/*magnitude of angular acceleration of AB*/
Real alpha_AB[3](each unit="rad/s^2");/*angular acceleration of AB*/

Real a_A_R[3](each unit="mm/s^2");/*right hand side of relative-acceleration equation*/
equation
alpha_OA=alpha_OA_mag*{0,0,1};
alpha_AB=alpha_AB_mag*{0,0,1};

a_A=cross(alpha_OA,r_A)+cross(w_OA,cross(w_OA,r_A));
a_B=cross(alpha_CB,r_B)+cross(w_CB,cross(w_CB,r_B));

a_AB_n=cross(w_AB,cross(w_AB,r_AB));
a_AB_t=cross(alpha_AB,r_AB);

a_A_R=a_B+a_AB_n+a_AB_t;

a_A[1]=a_A_R[1];
a_A[2]=a_A_R[2];

end Ex5_14;
