class Ex5_7
/*Solution-II (vector)*/
parameter Real r(unit="m")=300/1000;/*radius of the wheel*/
parameter Real v_O_mag(unit="m/s")=3;/*magnitude of the velocity of the wheel*/
parameter Real r_O_mag(unit="m/s")=200/1000;/*magnitude of the position  of the point A*/
parameter Real alpha_A_deg(unit="deg")=30;/*angular position of the point A w.r.t direction of v in degree unit*/
Real alpha_A(unit="rad");/*angular position of the point A w.r.t direction of v in radian unit*/

Real w[3](each unit="rad/s");/*angular velocity of the wheel*/
Real r_O[3](each unit="m");/*position  of the point A*/
Real v_O[3](each unit="m/s");/*velocity of the wheel*/
Real v_A[3](each unit="m/s");/*velocity of the point A*/
Real v_A_mag(unit="m/s");/*magnitude of the velocity of the point A*/
equation
alpha_A=Modelica.SIunits.Conversions.from_deg(alpha_A_deg);

w={0,0,-v_O_mag/r};
r_O=r_O_mag*{-cos(alpha_A),sin(alpha_A),0};
v_O={v_O_mag,0,0};

v_A=v_O+cross(w,r_O);
v_A_mag=Modelica.Math.Vectors.norm(v_A);

end Ex5_7;
