class Ex5_9
parameter Real pi = Modelica.Constants.pi;

parameter Real AG(unit="m")=250/1000;/*length of AB*/
parameter Real GB(unit="m")=100/1000;/*length of GB*/
parameter Real r(unit="m")=125/1000;/*length of r*/
parameter Real w(unit="rad/s")=1500*((2*pi)/60);/*angular velocity of B*/

parameter Real theta_B_deg(unit="deg")=60;/*angular position of the point B in degree unit*/
Real theta_B(unit="rad");/*angular position of the point B in radian unit*/
Real v_B(unit="m/s");/*crank pin velocity-B*/

Real beta(unit="rad");/*angle betwen horizontal cylinderical axis and AB*/
Real beta1(unit="rad");/*angle betwen v_AB and v_A*/
Real beta2(unit="rad");/*angle betwen v_B and v_AB*/

Real v_A(unit="m/s");/*velocity of A*/
Real v_AB(unit="m/s");/*velocity of A w.r.t B*/
Real w_AB(unit="rad/s");/*angular velocity of AB*/

Real v_GB(unit="m/s");/*velocity of G w.r.t B*/
Real v_G(unit="m/s");/*velocity of G*/
equation
theta_B=Modelica.SIunits.Conversions.from_deg(theta_B_deg);
v_B=r*w;
r/sin(beta)=(AG+GB)/sin(theta_B);
beta1=pi/2-beta;
beta2=pi-((30*pi)/180)-beta1;
v_A/sin(beta2)=v_B/sin(beta1);
v_AB/sin((30*pi)/180)=v_B/sin(beta1);
w_AB=v_AB/(AG+GB);
v_GB=GB*w_AB;

v_G=sqrt(v_B^2+v_GB^2-2*v_B*v_GB*cos(beta2));




end Ex5_9;
