class Ex7_1
parameter Real pi = Modelica.Constants.pi;

parameter Real OA(unit="m")=0.8;/*arm length*/
Real r[3](each unit="m");/*position vector of A*/

parameter Real N(unit="rad/s")=(60*2*pi)/60;/*angular velocity about z-axis*/
parameter Real beta_dot(unit="rad/s")=4;/*raised rate of arm*/

parameter Real beta_deg(unit="deg")=30;/*angular position of arm in degree unit*/
Real beta(unit="rad");/*angular position of arm in radian unit*/

Real w_x[3](each unit="rad/s");/*vector form of raised rate of arm about x-axis*/ 
Real w_z[3](each unit="rad/s");/*vector form of angular velocity about z-axis*/
Real w[3](each unit="rad/s");/*angular velocity of OA*/

Real w_x_dot[3](each unit="rad/s^2");/*1st derivative of w_x*/
Real w_z_dot[3](each unit="rad/s^2");/*1st derivative of w_z*/
Real alpha[3](each unit="rad/s^2");/*angular acceleration of OA*/

Real v[3](each unit="m/s");/*velocity of point A*/
Real a[3](each unit="m/s^2");/*acceleration of point A*/
equation
beta=Modelica.SIunits.Conversions.from_deg(beta_deg);
w_x={beta_dot,0,0};
w_z={0,0,N};
w=w_x+w_z;
w_x_dot=cross(w_z,w_x);
w_z_dot={0,0,0};
alpha=w_x_dot+w_z_dot;
r={0,OA*cos(beta),OA*sin(beta)};
v=cross(w,r);
a=cross(alpha,r)+cross(w,cross(w,r));


end Ex7_1;
