class Ex7_4
parameter Real w1(unit="rad/s")=6;/*angular velocity of crank AB*/
parameter Real AD(unit="mm")=50;/*length of AD*/
parameter Real BC(unit="mm")=100;/*length of BC*/
parameter Real BY(unit="mm")=100;/*length of BY*/

Real w2(unit="rad/s");/*angular velocity of crank DA*/

Real w_n[3](each unit="rad/s");/*angular velocity of link AB*/
Real w_n_mag(unit="rad/s");/*magnitude of angular velocity of link AB*/
Real w_nx(unit="rad/s");/*x-component of angular velocity of link AB*/
Real w_ny(unit="rad/s");/*y-component of angular velocity of link AB*/
Real w_nz(unit="rad/s");/*z-component of angular velocity of link AB*/

Real v_A[3](each unit="mm/s");/*velocity of A*/
Real v_B[3](each unit="mm/s");/*velocity of B*/

Real v_A_R[3](each unit="mm/s");/*right side of relative velocity equation*/

parameter Real r_AB[3](each unit="mm")={50,100,100};/*position of A w.r.t B*/

Real w2_dot(unit="rad/s^2");/*angular acceleration of crank AD*/
Real a_A[3](each unit="mm/s^2");/*acceleration of A*/
Real a_B[3](each unit="mm/s^2");/*acceleration of B*/
Real a_A_R[3](each unit="mm/s^2");/*right side of relative acceleration equation*/

Real w_n_dot[3](each unit="rad/s^2");/*angular acceleration of link AB*/
Real w_n_dot_mag(unit="rad/s^2");/*magnitude of angular acceleration of link AB*/
Real w_nx_dot(unit="rad/s^2");/*x-component of angular acceleration of link AB*/
Real w_ny_dot(unit="rad/s^2");/*y-component of angular acceleration of link AB*/
Real w_nz_dot(unit="rad/s^2");/*z-component of angular acceleration of link AB*/

equation
w_n={w_nx,w_nz,w_ny};
v_A={0,AD*w2,0};
v_B={BC*w1,0,0};

v_A_R=v_B+cross(w_n,r_AB);

v_A[1]=v_A_R[1];
v_A[2]=v_A_R[2];
v_A[3]=v_A_R[3];

sum(w_n.*r_AB)=0;
w_n_mag=Modelica.Math.Vectors.norm(w_n);

w_n_dot={w_nx_dot,w_ny_dot,w_nz_dot};
a_A={AD*w2^2,AD*w2_dot,0};
a_B={0,0,BC*w1^2};

a_A_R=cross(w_n_dot,r_AB)+cross(w_n,cross(w_n,r_AB));
a_A[1]=a_A_R[1];
a_A[2]=a_A_R[2];
a_A[3]=a_A_R[3];

sum(w_n_dot.*r_AB)=0;
w_n_dot_mag=Modelica.Math.Vectors.norm(w_n_dot);

/*The  answer provided in the textbook is wrong*/

end Ex7_4;
