class Ex8_2
parameter Real m(unit="kg")=8;/*mass of the body*/
parameter Real k(unit="N/m")=32;/*stiffness of the spring*/
parameter Real x_0(unit="m")=0.2;/*initial displacement*/
parameter Real c(unit="N.s/m")=20;/*viscous damping coefficient*/

Real w_n(unit="rad/s");/*natural frequency */
Real eta;/*damping ratio*/
Real w_d(unit="rad/s");/*damped natural frequency */
Real x(unit="m");/*displacement as a function of time*/
Real x_2(unit="m");/*displacement at 2 s*/

equation
w_n=sqrt(k/m);
eta=c/(2*m*w_n);
w_d=w_n*sqrt(1-eta^2);
x=0.256*exp(-eta*w_n*time)*sin(w_d*time+0.896);
when time==2 then
x_2=x;
end when;


end Ex8_2;
