class Ex8_4
parameter Real m(unit="kg")=50;/*mass of the body*/
parameter Real k(unit="N/m")=7500;/*stiffness of the spring*/
parameter Real n=4;/*number of spring*/
Real x_B(unit="m");/*initial displacement*/
Real b(unit="m");/*static spring deflection*/

Real w_n(unit="rad/s");/*resonant natural frequency */
Real w(unit="rad/s");/*impressed frequency */

Real X(unit="m");/*amplitude of the stady state motion of the instrument*/
equation
x_B=0.002*cos(50*time);
w_n=sqrt((n*k)/m);
w=50;
b=0.002;
X=b/(1-(w/w_n)^2);
/*The  answer may slightly vary due to  rounding off values*/
end Ex8_4;
