class Ex1_1
/*mass unit conversion from kg to slug 1slug=14.594 kg */
/*weight unit conversion from N to lb 1lb=4.4482 N */

parameter Real m_SI(unit="kg")=50;/*mass of the payload module in SI unit*/
Real m_slug(unit="slug");/*mass of the payload module in slug unit*/

parameter Real g(unit="m/s^2")=9.80665;/*acceleration due to gravity*/
Real W_SI_a(unit="N");/*weight of the module on the surface level in SI unit*/
Real W_lb_a(unit="lb");/*weight of the module on the surface level in english engineering unit*/

parameter Real g_0(unit="m/s^2")=9.825;/*acceleration due to gravity for nonrotating earth*/
Real g_h(unit="m/s^2");/*acceleration due to gravity for nonrotating earth at 300 km*/

parameter Real R(unit="km")=6371;/*radius of the earth*/
parameter Real h(unit="km")=300;/*altitude above ground*/

Real W_SI_b(unit="N");/*weight of the module at 300km altitude in SI unit*/
Real W_lb_b(unit="lb");/*weight of the module at 300km altitude in english engineering unit*/

equation
W_SI_a=m_SI*g;
W_lb_a=W_SI_a/4.4482;
m_slug=m_SI/14.594;

g_h=g_0*(R^2/(R+h)^2);
W_SI_b=m_SI*g_h;
W_lb_b=W_SI_b/4.4482;
/*The  answer may slightly vary due to  rounding off values*/
end Ex1_1;
