class Ex2_10
parameter Real theta_deg(unit="deg")=30;/*angular position of the rocket in degree unit*/
Real theta(unit="rad");/*angular position of the rocket in radian unit*/
parameter Real theta_dot_deg(unit="deg/s")=0.80;/*1st derivative of theta in degree unit*/
Real theta_dot(unit="rad/s");/*1st derivative of theta in radian unit*/
Real theta_ddot(unit="rad/s^2");/*2nd derivative of theta*/

parameter Real r(unit="m")=8*10^4;/*radial distance of the rocket*/
parameter Real r_dot(unit="m/s")=1200;/*1st derivative of r*/
Real r_ddot(unit="m/s^2");/*2nd derivative of r*/

Real v_r(unit="m/s");/*radial velocity of the rocket*/
Real v_theta(unit="m/s");/*angular velocity of the rocket*/
Real v(unit="m/s");/*absolute velocity of the rocket*/

parameter Real a(unit="m/s^2")=9.2;/*total acceleration of the rocket due to gravity*/
Real a_r(unit="m/s^2");/*radial acceleration of the rocket*/
Real a_theta(unit="m/s^2");/*angular acceleration of the rocket*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
theta_dot=Modelica.SIunits.Conversions.from_deg(theta_dot_deg);

v_r=r_dot;
v_theta=r*theta_dot;
v=sqrt(v_r^2+v_theta^2);

a_r=-a*cos(theta);
a_theta=a*sin(theta);

a_r=r_ddot-r*theta_dot^2;
a_theta=r*theta_ddot+2*r_dot*theta_dot;

end Ex2_10;
