class Ex2_13
/*Using vector Algebra Approach*/

//parameter Real pi = Modelica.Constants.pi;
parameter Real v_A(unit="km/h")=800;/*velocity of the aircraft-A*/

parameter Real alpha1_deg(unit="deg")=45;/*actual nose direction of aircraft-B in degree unit*/
Real alpha1(unit="rad");/*actual nose direction of aircraft-B in radian unit*/

parameter Real alpha2_deg(unit="deg")=60;/*relative nose direction of aircraft-B w.r.t. aircraft-A in degree unit*/
Real alpha2(unit="rad");/*relative nose direction of aircraft-B w.r.t. aircraft-A in radian unit*/

Real v_B(unit="km/h");/*magnitude of the true velocity of the aircraft-B*/
Real V_B[2](each unit="km/h");/*true velocity vector of the aircraft-B*/

Real v_BA(unit="km/h");/*magnitude of the relative velocity of the aircraft-B w.r.t. aircraft-A*/
Real V_BA[2](each unit="km/h");/*relative velocity vector of the aircraft-B w.r.t. aircraft-A*/

equation
alpha1=Modelica.SIunits.Conversions.from_deg(alpha1_deg);
alpha2=Modelica.SIunits.Conversions.from_deg(alpha2_deg);

v_B*cos(alpha1)=v_A-v_BA*cos(alpha2);
v_B*sin(alpha1)=v_BA*sin(alpha2);

V_B={v_B*cos(alpha1),v_B*sin(alpha1)};
V_BA={-v_BA*cos(alpha2),v_BA*sin(alpha2)};

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_13;
