class Ex2_14
parameter Real v_A_kmph(unit="km/h")=72;/*actual velocity of car A in km/h unit*/
Real v_A(unit="m/s");/*actual velocity of car A in m/s unit*/

parameter Real v_B_kmph(unit="km/h")=54;/*actual velocity of car A in km/h unit*/
Real v_B(unit="m/s");/*actual velocity of car A in m/s unit*/

parameter Real alpha1(unit="deg")=30;/*angle between radius of path and x-direction in degree unit*/
Real alpha1_rad(unit="deg");/*angle between radius of path and x-direction in radian unit*/
parameter Real alpha2(unit="deg")=90-30;/*angle between car A and B in degree unit*/
Real alpha2_rad(unit="deg");/*angle between car A and B in radian unit*/

Real v_BA(unit="m/s");/*magnitude of the relative velocity of the car-B w.r.t. car-A*/
Real theta_rad(unit="rad");/*direction of v_BA w.r.t. car-A in radian unit*/
Real theta(unit="deg");/*direction of v_BA w.r.t. car-A in deg unit*/

Real rho(unit="m")=150;/*radius of the rounding car*/

parameter Real a_A(unit="m/s^2")=1.2;/*acceleration of car A*/
Real a_B(unit="m/s^2");/*acceleration of car B*/
Real a_BA_x(unit="m/s^2");/*x-component of acceleration of car B w.r.t. car-A*/
Real a_BA_y(unit="m/s^2");/*y-component of acceleration of car B w.r.t. car-A*/
Real a_BA(unit="m/s^2");/*magnitude of acceleration of car B w.r.t. car-A*/

Real beta_rad(unit="rad");/*direction of a_BA w.r.t. car-A in radian unit*/
Real beta(unit="deg");/*direction of a_BA w.r.t. car-A in degree unit*/
equation
v_A=v_A_kmph*(1000/3600);
v_B=v_B_kmph*(1000/3600);

alpha1_rad=Modelica.SIunits.Conversions.from_deg(alpha1);
alpha2_rad=Modelica.SIunits.Conversions.from_deg(alpha2);

v_BA^2=v_A^2+v_B^2-2*v_A*v_B*cos(alpha2_rad);/*Law of cosine*/
v_B/sin(theta_rad)=v_BA/sin(alpha2_rad);/*Law of sine*/
theta=Modelica.SIunits.Conversions.to_deg(theta_rad);

a_B=v_B^2/rho;
a_BA_x=a_B*cos(alpha1_rad)-a_A;
a_BA_y=a_B*sin(alpha1_rad);
a_BA=sqrt(a_BA_x^2+a_BA_y^2);

a_B/sin(beta_rad)=a_BA/sin(alpha1_rad);/*Law of sine*/
beta=Modelica.SIunits.Conversions.to_deg(beta_rad);

/*the answer of beta given in the book is wrong*/
end Ex2_14;
