class Ex2_7
parameter Real v_A_kmph(unit="km/h")=100;/*velocity at point A in km/h unit*/
Real v_A(unit="m/s");/*velocity at point A in m/s unit*/
parameter Real v_C_kmph(unit="km/h")=50;/*velocity at point C in km/h unit*/
Real v_C(unit="m/s");/*velocity at point C in m/s unit*/

/*Number-a*/
parameter Real s(unit="m")=120;/*distance from A to C*/ 
Real a_t(unit="m/s^2");/*constant deceleration along the path*/
parameter Real a_A(unit="m/s^2")=3;/*total acceleration at point A*/
Real a_nA(unit="m/s^2");/*normal component of acceleration at point A*/
Real rho_A(unit="m");/*radius of curvature at point A*/

/*Number-b*/
Real a_nB(unit="m/s^2");/*normal component of acceleration at point B*/
Real a_B(unit="m/s^2");/*total acceleration at point B*/

/*Number-c*/
parameter Real rho_C(unit="m")=150;/*radius of curvature at point C*/
Real a_nC(unit="m/s^2");/*normal component of acceleration at point C*/
Real a_C[2](each unit="m/s^2");/*total acceleration at point C*/
Real a_C_mag(unit="m/s^2");/*magnitude of total acceleration at point C*/
equation
v_A=v_A_kmph*(1000/3600);
v_C=v_C_kmph*(1000/3600);

/*Number-a*/
a_t=(1/(2*s))*(v_C^2-v_A^2);
a_nA^2=a_A^2-a_t^2;
rho_A=v_A^2/a_nA;

/*Number-b*/
a_nB=0;
a_B=a_t;

/*Number-c*/
a_nC=v_C^2/rho_C;
a_C={a_nC,a_t};
a_C_mag=sqrt(a_nC^2+a_t^2);

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_7;
