class Ex2_8
parameter Real a_h(unit="m/s^2")=6;/*horizontal component of acceleration*/
parameter Real g(unit="m/s^2")=9;/*downword component of acceleration*/

parameter Real alpha_deg(unit="deg")=15;/*direction of the mass center G in degree unit*/
Real alpha(unit="rad");/*direction of the mass center G in radian unit*/

Real a_n(unit="m/s^2");/*normal component of acceleration*/
Real a_t(unit="m/s^2");/*tangential component of the acceleration*/

/*Number-a*/
parameter Real v_kmph(unit="km/h")=20*10^3;/*velocity along the trajectory in km/h unit*/
Real v(unit="m/s");/*velocity along the trajectory in m/s unit*/
Real rho(unit="m");/*radius of curvature*/

/*Number-b*/
Real v_dot(unit="m/s^2");/*the rate at which the speed v is increasing*/

/*Number-c*/
Real beta_dot(unit="rad/s");/*the angular rate of the radial line from G to the center of curveture C*/

/*Number-d*/
Real a[2](each unit="m/s^2");/*total acceleration */

equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
a_n=g*cos(alpha)-a_h*sin(alpha);
a_t=g*sin(alpha)+a_h*cos(alpha);

/*Number-a*/
v=v_kmph*(1000/3600);
rho=v^2/a_n;

/*Number-b*/
v_dot=a_t;

/*Number-c*/
beta_dot=v/rho;

/*Number-d*/
a={a_n,a_t};

/*The  answer may slightly vary due to  rounding off values*/
end Ex2_8;
