class Ex3_11
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=50;/*mass of the crete*/
parameter Real v_1(unit="m/s")=4;/*velocity at point A*/
Real v_2(unit="m/s");/*velocity at point B*/

parameter Real mu=0.30;/*coefficient of kinetic friction*/
parameter Real s(unit="m")=10;/*distance from A to B*/
parameter Real alpha_deg(unit="deg")=15;/*elevation angle of the crete in degree unit*/
Real alpha(unit="rad");/*elevation angle of the crete in radian unit*/

Real R(unit="N");/*normal force on the crete*/
Real U_12(unit="J");/*total work done on the crete*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
R=m*g*cos(alpha);
U_12=m*g*(s*sin(alpha))-mu*R*s;
(1/2)*m*v_1^2+U_12=(1/2)*m*v_2^2;
end Ex3_11;

