class Ex3_16
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=3;/*mass of the slider*/
parameter Real k(unit="N/m")=350;/*stifness of the spring*/
parameter Real h(unit="m")=0.6;/*unstretched length of the spring*/

parameter Real T1(unit="J");/*kinetic energy at point 1*/
parameter Real U_12(unit="J")=0;/*work done*/

Real V1_g(unit="J");/*gravitational potential energy at position 1*/ 
Real V2_g(unit="J");/*gravitational potential energy at position 2*/
Real V1_e(unit="J");/*elastic potential energy at position 1*/ 
Real V2_e(unit="J");/*elastic potential energy at position 2*/

Real v2(unit="m/s");/*velocity of the slider at position 2*/
equation
V1_g=0;
V2_g=-m*g*h;

V1_e=(1/2)*k*h^2;
V2_e=(1/2)*k*(h*sqrt(2)-h)^2;

T1+V1_e+U_12=(1/2)*m*v2^2+V2_g+V2_e;
end Ex3_16;
