class Ex3_20
parameter Real g[3](each unit="m/s^2")={0,0,9.81};/*acceleration due to gravity*/
parameter Real m(unit="kg")=0.2;/*mass of the the particle*/
Real G[3](each unit="N.s");/*linear momentum*/
Real G_dot[3](each unit="N");/*derivative of linear momentum*/
Real F_t[3](each unit="N");/*force on the particle function of time*/
Real F[3](each unit="N");/*force on the particle at time 2 second*/
Real F_M(unit="N");/*magnitude of the force on the particle at time 2 second*/
equation
G={0,(3/2)*(time^2+3),-(2/3)*(time^3-4)};
G_dot=der(G);
F_t-m*g=G_dot;
when time==2 then
F=F_t;
F_M=Modelica.Math.Vectors.norm(F);
end when;
annotation(experiment(StartTime=0, StopTime=2));
end Ex3_20;
