class Ex3_30
parameter Real v1(unit="m/s")=6;/*initial magnitude of the velocity of the ball 1*/
parameter Real alpha_deg(unit="deg")=30;/*angle of the normal n to the contacting surface with the direction of v1 in degree unit*/
Real alpha(unit="rad");/*angle of the normal n to the contacting surface with the direction of v1 in radian unit*/

Real v1_n(unit="m/s");/*n-component of the velocity of the ball 1 before impact*/
Real v1_t(unit="m/s");/*t-component of the velocity of the ball 1 before impact*/
Real v1_n_das(unit="m/s");/*n-component of the velocity of the ball 1 after impact*/
Real v1_t_das(unit="m/s");/*t-component of the velocity of the ball 1 after impact*/

Real v2_n(unit="m/s");/*n-component of the velocity of the ball 2 before impact*/
Real v2_t(unit="m/s");/*t-component of the velocity of the ball 2 before impact*/
Real v2_n_das(unit="m/s");/*n-component of the velocity of the ball 2 after impact*/
Real v2_t_das(unit="m/s");/*t-component of the velocity of the ball 2 after impact*/

parameter Real e=0.6;/*coefficient of restitution*/

Real v1_das(unit="m/s");/*final velocity of the ball 1*/
Real v2_das(unit="m/s");/*final velocity of the ball 2*/

Real theta_das(unit="rad");/*angle between v1_das and t-direction in radian unit*/
Real theta_deg_das(unit="deg");/*angle between v1_das and t-direction in degree unit after impact*/
equation
alpha=Modelica.SIunits.Conversions.from_deg(alpha_deg);
v1_n=v1*cos(alpha);
v1_t=v1*sin(alpha);
v2_n=0;
v2_t=0;

v1_n+v2_n=v1_n_das+v2_n_das;

e=(v2_n_das-v1_n_das)/(v1_n-v2_n);

v1_t_das=v1_t;
v2_t_das=v2_t;

v1_das=sqrt(v1_n_das^2+v1_t_das^2);
v2_das=sqrt(v2_n_das^2+v2_t_das^2);
tan(theta_das)=v1_n_das/v1_t_das;
theta_deg_das=Modelica.SIunits.Conversions.to_deg(theta_das);




end Ex3_30;
