class Ex5_10
parameter Real r(unit="m")=450/1000;/*distance between point O and bar*/
Real OA(unit="m");/*length of OA*/
parameter Real theta_deg(unit="deg")=30;/*angular of OB w.r.t base in degree unit*/
Real theta(unit="rad");/*angular position of OB w.r.t base in radian unit*/

parameter Real v_B(unit="m/s")=0.25;/*velocity of point B*/
Real v_A(unit="m/s");/*velocity of point A*/
Real w(unit="rad/s");/*angular velocity of slotted arm*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
OA=r/cos(theta);
v_A=v_B*cos(theta);
w=v_A/OA;
end Ex5_10;
