class Ex5_16
parameter Real r[3](each unit="m")={150/1000,0,0};/*position  of the point A*/

parameter Real w[3](each unit="rad/s")={0,0,4};/*angular velocity of the disk*/
parameter Real w_dot[3](each unit="rad/s^2")={0,0,-10};/*angular acceleration of OA*/

parameter Real r_dot[3](each unit="m/s")={125/1000,0,0};/* relative velocity of point A*/
parameter Real r_ddot[3](each unit="m/s")={2025/1000,0,0};/* relative acceleration of point A*/

Real v_A[3](each unit="m/s");/*velocity of the point A*/
Real v_A_mag(unit="m/s");/*magnitude of velocity of the point A*/

Real a_A[3](each unit="m/s^2");/*acceleration of A*/
Real a_A_mag(unit="m/s^2");/*magnitude of acceleration of A*/
equation
v_A=cross(w,r)+r_dot;
v_A_mag=Modelica.Math.Vectors.norm(v_A);

a_A=cross(w,cross(w,r))+cross(w_dot,r)+2*cross(w,r_dot)+r_ddot;
a_A_mag=Modelica.Math.Vectors.norm(a_A);
end Ex5_16;
