class Ex6_1
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=1500;/*mass of the truck*/
parameter Real v(unit="m/s")=(50*1000)/3600;/*speed of the truck*/
parameter Real s(unit="m")=60;/*distance travelled by truck*/
parameter Real Inclination=10/100;/*inclination of the path*/
Real theta(unit="rad");/*incline angle of the path*/
parameter Real mu=0.8;/*coefficient of friction*/

parameter Real BG(unit="m")=1500/1000;/*distance between B and G*/
parameter Real AG(unit="m")=1500/1000;/*distance between A and G*/
parameter Real G(unit="m")=600/1000;/*distance between path and G*/

Real a_bar(unit="m/s^2");/*acceleration of the truck*/
Real W(unit="N");/*weight of the truck*/
Real W_n(unit="N");/*vertical component of the weight of the truck*/
Real W_h(unit="N");/*horizonatl component of the weight of the truck*/

Real F(unit="N");/*frictional force*/
Real N1(unit="N");/*normal force in front wheel*/
Real N2(unit="N");/*normal force in rear wheel*/
equation
theta=atan(Inclination);
W=m*g;
W_n=W*cos(theta);
W_h=W*sin(theta);

v^2=2*a_bar*s;

F-W_h=m*a_bar;
N1+N2-W_n=0;
AG*N1+G*F-BG*N2=0;

/*The  answer may slightly vary due to  rounding off values*/

end Ex6_1;
