class Ex6_11
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_wheel(unit="kg")=30;/*mass of the each wheel*/
parameter Real m_bar(unit="kg")=10;/*mass of the each bar*/
parameter Real m_collar(unit="kg")=7;/*mass of the collar*/

parameter Real AB(unit="m")=375/1000;/*length of AB*/
parameter Real r(unit="m")=150/1000;/*radius of the wheel*/
parameter Real k_O(unit="m")=100/1000;/*radius of giration of the wheel*/
parameter Real k(unit="N/m")=30*10^3;/*stiffness of the spring*/

parameter Real theta_deg(unit="deg")=45;/*initial anglular position of the bar w.r.t horizontal line in degree unit*/
Real theta(unit="rad");/*initial anglular position of the bar w.r.t horizontal line in radian unit*/

Real w(unit="rad/s");/*angular velocity of the links*/
Real v_B(start=0.001,unit="m/s");/*velocity v_B of the collar*/
Real d(unit="m");/*distance drop by collar*/

Real U_12_das(unit="J");/*work done on the system for stage 1 to 2*/

Real T1(unit="J");/*kinetic energy of the system at position 1*/
Real V1(unit="J");/*gravitational potential energy at position 1*/
Real T2(unit="J");/*kinetic energy of the system at position 2*/
Real V2(unit="J");/*gravitational potential energy at position 2*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
w=v_B/AB;
d=AB*sin(theta);

U_12_das=0;
T1=0;
T2=2*(1/2)*(1/3)*m_bar*AB^2*w^2+(1/2)*m_collar*v_B^2;
V1=2*m_bar*g*(d/2)+m_collar*g*d;
V2=0;

T1+V1+U_12_das=T2+V2;


end Ex6_11;
