class Ex6_7
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=30;/*mass of bar*/

parameter Real r_AG(unit="m")=0.6;/*length of AG*/
parameter Real r_BG(unit="m")=0.6;/*length of BG*/

parameter Real P(unit="N")=150;/*applied force at A*/

parameter Real theta_deg(unit="deg")=30;/*angle between AB and y-axis in degree unit*/
Real theta(unit="rad");/*angle between AB and y-axis in radian unit*/

Real a_bar(unit="m/s^2");/*acceleration of the center G*/
Real alpha(unit="rad/s^2");/*angular acceleration of G*/
Real a_bar_x(unit="m/s^2");/*x-component of acceleration of the center G*/
Real a_bar_y(unit="m/s^2");/*y-component of acceleration of the center G*/

Real A(unit="N");/*force at A*/
Real B(unit="N");/*force at B*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
a_bar=r_BG*alpha;

a_bar_x=a_bar*cos(theta);
a_bar_y=a_bar*sin(theta);

P*(r_AG*cos(theta))-A*(r_AG*sin(theta))+B*(r_BG*cos(theta))=(1/12)*m*(r_AG+r_BG)^2*alpha;

P-B=m*a_bar_x;
A-m*g=m*a_bar_y;

end Ex6_7;
