class Ex6_9
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m(unit="kg")=40;/*mass of the wheel*/

parameter Real r_OA(unit="m")=200/1000;/*radius of the outer rim*/
parameter Real r_OC(unit="m")=100/1000;/*radius of the inner rim*/
parameter Real k_O(unit="m")=150/1000;/*radius of giration of the wheel*/
parameter Real s(unit="m")=3;/*displacement of the center*/

parameter Real P(unit="N")=100;/*applied force at A*/

parameter Real theta_deg(unit="deg")=15;/*inclination of the path in degree unit*/
Real theta(unit="rad");/*inclination of the path in radian unit*/

Real v_bar(unit="m/s");/*velocity of the center of the wheel*/
Real w(start=0.001,unit="rad/s");/*angular velocity of the wheel*/

Real U_12(unit="J");/*work done on the wheel*/
Real T1(unit="J");/*initial kinetic energy*/
Real T2(unit="J");/*final kinetic energy*/
Real Power(unit="W");/*power input from the force*/
equation
theta=Modelica.SIunits.Conversions.from_deg(theta_deg);
U_12=P*((r_OA+r_OC)/r_OC)*s-(m*g*sin(theta))*s;
T1=0;
v_bar=r_OC*w;
T2=(1/2)*m*(r_OC*w)^2+(1/2)*m*k_O^2*w^2;
T1+U_12=T2;
Power=P*(r_OA+r_OC)*w;
/*The  answer may slightly vary due to  rounding off values*/
end Ex6_9;
