class Ex7_2
parameter Real pi = Modelica.Constants.pi;

parameter Real gama_deg(unit="deg")=30;/*angular position of z-axis in degree unit*/
Real gama(unit="rad");/*angular position of z-axis in radian unit*/
Real K[3];/*vector form of Z-axis w.r.t. xyz axis*/

parameter Real w_0_mag(unit="rad/s")=(120*2*pi)/60;/*magnitude of angular velocity of rotor about z-axis*/
parameter Real omega_mag(unit="rad/s")=(60*2*pi)/60;/*magnitude of angular velocity of disk about Z-axis*/

Real w_0[3](each unit="rad/s");/*angular velocity of rotor about z-axis*/ 
Real omega[3](each unit="rad/s");/*angular velocity of disk about Z-axis*/

Real w[3](each unit="rad/s");/*total angular velocity of the disk*/
Real alpha[3](each unit="rad/s^2");/*total angular acceleration of the disk*/

parameter Real OC(unit="m")=250/1000;/*length of OC*/
parameter Real CA(unit="m")=125/1000;/*length of CA*/
Real r[3](each unit="m");/*position vector of A*/

Real v[3](each unit="m/s");/*velocity of point A*/
Real a[3](each unit="m/s^2");/*acceleration of point A*/

equation
gama=Modelica.SIunits.Conversions.from_deg(gama_deg);
K={0,cos(gama),sin(gama)};
w_0=w_0_mag*{0,0,1};
omega=omega_mag*K;

w=w_0+omega;
alpha=cross(omega,w);

r={0,CA,OC};
v=cross(w,r);
a=cross(alpha,r)+cross(w,v);

end Ex7_2;
