class Ex7_8
parameter Real pi = Modelica.Constants.pi;

parameter Real m(unit="kg")=1000;/*mass of rotor*/
parameter Real k_o(unit="m")=200/1000;/*radius of gyration*/
parameter Real p(unit="rad/s")=5000*((2*pi)/60);/*rotational speed of the rotor*/
parameter Real AB(unit="m")=(600+900)/1000;/*distance between A and B*/

parameter Real R1(unit="N")=5890;/*vertical component of the bearing reaction at A*/
parameter Real R2(unit="N")=3920;/*vertical component of the bearing reaction at B*/
Real del_R(unit="N");/*increment bearing reaction*/
Real R_A(unit="N");/*bearing reaction at A*/
Real R_B(unit="N");/*bearing reaction at B*/

Real omega(unit="rad/s");/*precession velocity*/
parameter Real rho(unit="m")=400;/*turn radius*/
parameter Real v(unit="m/s")=25*0.514;/*speed of the ship*/
equation
R_A=R1-del_R;
R_B=R2-del_R;
omega=v/rho;
AB*del_R=m*k_o^2*omega*p;

end Ex7_8;
