class Ex2_13
parameter Real g(unit="m/s^2")=9.83;/*acceleration due to gravity*/

parameter Real v_1o(unit="m/s")=120;/*initial velocity of the 1st particle*/
Real T(unit="s",start=0.001,min=0.001);/*flight time of the 1st particle*/
parameter Real h1(unit="m")=0;/*distance from ground of the 1st particle  after flight time T second*/
Real T2(unit="s");/*flight time of the 2nd particle*/
parameter Real h2(unit="m")=0;/*distance from ground of the 2nd particle  after flight time T2 second*/
Real v_2max(unit="m/s");/*maximum throw velocity of particle 2*/
equation
T=(2*v_1o)/g;
T2=T-10;
h2=v_2max*T2-(1/2)*g*T2^2;
end Ex2_13;
