class Ex2_18
parameter Real g(unit="m/s^2")=9.83;/*acceleration due to gravity*/

parameter Real v_0(unit="m/s")=30;/*projection speed of the particle*/
parameter Real beta_deg(unit="deg")=30;/*angle between plane and horizontal in degree unit*/
Real beta(unit="rad");/*angle between plane and horizontal in radian unit*/
Real theta(unit="rad");/*angle of direction of particle w.r.t. plane in radian unit*/
Real theta_deg(unit="deg");/*angle of direction of particle w.r.t. plane in degree unit*/
Real v_Ax(unit="m/s");/*component of velocity of the particle along x-axis*/
Real T(unit="s");/*toal flight time*/
equation
beta=Modelica.SIunits.Conversions.from_deg(beta_deg);
v_Ax=v_0*cos(theta)-g*sin(beta)*T;
v_Ax=0;
T=(2*v_0*sin(theta))/(g*cos(beta));
theta_deg=Modelica.SIunits.Conversions.to_deg(theta);

end Ex2_18;
