class Ex2_22
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real x(unit="m")=1.8;/*x-coordinate of a point Q*/
parameter Real y(unit="m")=-1.4;/*y-coordinate of a point-Q*/

Real v_0(unit="m/s");/*projection speed of the mountaineer*/

Real theta_rad(unit="rad");/*projection angle w.r.t. x-axix in radian unit*/
Real theta_deg(unit="deg");/*projection angle w.r.t. x-axix in degree unit*/

equation
y+(g*x^2)/(2*v_0^2)=v_0^2/(2*g);
tan(theta_rad)=x/((g*x^2)/v_0^2);
theta_deg=Modelica.SIunits.Conversions.to_deg(theta_rad);

end Ex2_22;
