class Ex2_4
parameter Real pi = Modelica.Constants.pi;

parameter Real v_A(unit="m/s")=2;/*velocity of the particle A along groove*/
Real v_A1(unit="m/s");/*component of velocity of the particle A along string*/
Real v_B(unit="m/s");/*velocity of the particle B along groove*/
Real v_B1(unit="m/s");/*component of velocity of the particle B along string*/
parameter Real theta1_deg(unit="deg")=60;/*angle between direction of particle A and string in degree unit*/
Real theta1_rad(unit="rad");/*angle between direction of particle A and string in radian unit*/
Real theta2_rad(unit="rad");/*angle between direction of particle B and string in radian unit*/
equation
theta1_rad=Modelica.SIunits.Conversions.from_deg(theta1_deg);
theta2_rad=pi/2-theta1_rad;
v_A1=v_A*cos(theta1_rad);
v_B1=v_B*cos(theta2_rad);
v_B1=v_A1;
end Ex2_4;
