class Ex2_7
parameter Real v_w(unit="kmh^(-1)")=15;/*velocity of the water*/
parameter Real v_BW(unit="kmh^(-1)")=18;/*velocity of the boat w.r.t. water*/
parameter Real s(unit="m")=500;/*wide of the river*/
Real v_B(unit="kmh^(-1)");/*actaual velocity of the boat*/
Real theta_rad(unit="rad");/*direction of the velocity of the boat w.r.t. the water in radian unit*/

Real theta_deg(unit="deg");/*direction of the velocity of the boat w.r.t. the water in degree unit*/
Real t(unit="min");/*required time*/
equation
v_BW*sin(theta_rad)=v_w;
theta_deg=Modelica.SIunits.Conversions.to_deg(theta_rad);
v_B=v_BW*cos(theta_rad);
t=s/(v_B*(1000/60));/*here v_B has been multilied by (1000/60) to convert the unit from kmp^(-1) to m/min*/ 
end Ex2_7;
