class Ex3_15
parameter Real pi = Modelica.Constants.pi;

parameter Real G(unit="m^3.kg^(-1).s^(-2)")=6.67*10^(-11);/*constant of the universal gravitational*/
parameter Real T(unit="s")=9.9*3600;/*period of rotation of the Jupiter*/
parameter Real m_J(unit="kg")=1897.27*10^24;/*mass of the Jupiter*/
parameter Real r_J(unit="m")=69.9*10^3*10^3;/*radius of the Jupiter*/ 
Real h(unit="m");/*altitude of the orbit from the Jupiter surface*/

Real r(unit="m");/*distance of the orbit from the center of the Jupiter*/
equation
r=((T*sqrt(G*m_J))/(2*pi))^(2/3);
h=r-r_J;
/*The  answer may slightly vary due to  rounding off values*/
end Ex3_15;
