class Ex3_17
parameter Real pi = Modelica.Constants.pi;

parameter Real G(unit="m^3.kg^(-1).s^(-2)")=6.67*10^(-11);/*constant of the universal gravitational*/
parameter Real m_E(unit="kg")=5.97*10^24;/*mass of the earth*/
parameter Real r_E(unit="m")=6.378*10^3*10^3;/*radius of the earth*/ 
Real h(unit="m");/*altitude of the satellite from the earth surface*/

Real r(unit="m");/*distance of the satellite from the center of the earth*/
Real T(unit="s");/*period of the satellite*/
parameter Real theta(unit="deg")=30;/*angle cover by imaging satellite*/
equation
T=(24*3600)*(theta/360);
r=((T*sqrt(G*m_E))/(2*pi))^(2/3);
r=r_E+h;



end Ex3_17;
