class Ex4_3
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=2;/*mass of the bob*/
parameter Real r(unit="m")=0.75;/*length of the string*/

Real v_a(unit="m/s");/*magnitude of the initial velocity of the bob for string*/
Real v_das(unit="m/s");/*velocity at the top position of the bob for string*/
Real v_b(unit="m/s");/*magnitude of the initial velocity of the bob for rod*/
parameter Real v(unit="m/s")=0;/*velocity at the top position of the bob for rod*/
equation
v_das^2/r=g;
(1/2)*m*v_a^2=(1/2)*m*v_das^2+m*g*(2*r);
(1/2)*m*v_b^2=(1/2)*m*v^2+m*g*(2*r);
end Ex4_3;
