class Ex5_18
parameter Real m_A(unit="kg")=20;/*mass of the particle A*/
parameter Real m_B(unit="kg")=4;/*mass of the particle B*/

parameter Real h(unit="cm")=7;/*distance between two parallel path*/
parameter Real r_A(unit="cm")=7;/*radius of the particle A*/
parameter Real r_B(unit="cm")=5;/*radius of the particle B*/
Real O_A_O_B(unit="cm");/*distance between the centers of the particle along y axis*/
Real theta(unit="rad");/*angle of y-axis w.r.t. horizontal*/

parameter Real e=0.4;/*coefficient of restitution*/

parameter Real u_A(unit="m/s")=1.5;/*speed of the particle A before collision*/
parameter Real u_B(unit="m/s")=4;/*speed of the particle B before collision*/

Real v_Ax(unit="m/s");/*speed of the particle A before collision along x-axis*/
Real v_Ay(unit="m/s");/*speed of the particle A before collision along y-axis*/
Real v_Bx(unit="m/s");/*speed of the particle B before collision along x-axis*/
Real v_By(unit="m/s");/*speed of the particle B before collision along y-axis*/

Real v_Ax_das(unit="m/s");/*speed of the particle A after collision along x-axis*/
Real v_Ay_das(unit="m/s");/*speed of the particle A after collision along y-axis*/
Real v_Bx_das(unit="m/s");/*speed of the particle B after collision along x-axis*/
Real v_By_das(unit="m/s");/*speed of the particle B after collision along y-axis*/

Real v_A_das(unit="m/s");/*magnitude of velocity of particle A after collsion*/
Real v_B_das(unit="m/s");/*magnitude of velocity of particle B after collsion*/
equation
O_A_O_B=r_A+r_B;
theta=asin(h/O_A_O_B);
v_Ax=u_A*sin(theta);
v_Ay=-u_A*cos(theta);
v_Bx=-u_B*sin(theta);
v_By=u_B*cos(theta);
e=(v_Ay_das-v_By_das)/(v_By-v_Ay);
v_Ax_das=v_Ax;
v_Bx_das=v_Bx;
m_A*v_Ay+m_B*v_By=m_A*v_Ay_das+m_B*v_By_das;
v_A_das=sqrt(v_Ax_das^2+v_Ay_das^2);
v_B_das=sqrt(v_Bx_das^2+v_By_das^2);
end Ex5_18;
