class Ex6_8
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real m(unit="kg")=1200;/*mass of the log*/
parameter Real AB(unit="m")=4;/*length of the log*/
parameter Real l(unit="m")=1.5;/*length of the rope*/
parameter Real h(unit="h")=2;/*height of the truck from the ground*/

Real theta(unit="rad");/*incline angle of the log in radian unit*/
Real T(unit="N");/*tension in the log*/
Real a_C(unit="m/s^2");/*minimum acceleration of the truck*/
equation
sin(theta)=h/(AB+l);
T*sin(theta)=m*g;
T*cos(theta)=m*a_C;
end Ex6_8;
