class Ex7_10
parameter Real pi = Modelica.Constants.pi;

parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real l(unit="m")=0.75;/*length of the string*/
parameter Real a(unit="m/s^2")=1.2;/*acceleration of the roof*/
Real g_das(unit="m/s^2");/*equivalent gravitational acceleration*/
Real w_n(unit="rad/s");/*natural circular frequency of the block*/ 
Real f_n(unit="Hz");/*frequency of oscillation*/
equation
g_das=sqrt(a^2+g^2);
w_n=sqrt(g_das/l);
f_n=w_n/(2*pi);
end Ex7_10;
