class Ex7_14
parameter Real pi = Modelica.Constants.pi;
parameter Real m(unit="kg")=15;/*mass of the system*/
parameter Real k(unit="N/m")=100/10^(-2);/*stiffness of the spring*/
parameter Real zeta=0.25;/*damping factor*/
Real w_n(unit="rad/s");/*natural circular frequency of the system*/ 
Real w_d(unit="rad/s");/*damped natural frequency of the system*/
Real T(unit="s");/*time period of the oscillation*/
Real X_2_by_X_1;/*ratio of amplitude of two successive oscillation*/
Real X_mag_drop(unit="%");/*percentage drop of amplitude*/
equation
w_n=sqrt(k/m);
w_d=w_n*sqrt(1-zeta^2);
T=(2*pi)/w_d;
X_2_by_X_1=exp(-zeta*w_n*T);
X_mag_drop=(1-X_2_by_X_1)*100;
end Ex7_14;
