class Ex2_3
parameter Real pi = Modelica.Constants.pi;

parameter Real r(unit="m")=3;/*radius of the semicircular path*/
parameter Real v_uniform(unit="m/s")=1.5;/*uniform speed of the particle*/
parameter Real theta(unit="deg")=30;/*angle between radius of the semicircular path and x-axis in degree unit*/
Real theta_rad(unit="rad");/*angle between radius of the semicircular path and x-axis in radian unit*/

Real s_mag(unit="m");/*magnitude of vector AB*/
Real s[2](each unit="m");/*vector AB*/
Real s_x(unit="m");/*x-component of s*/
Real s_y(unit="m");/*y-component of s*/
Real ACB(unit="m");/*length of semicircular path*/
Real t(unit="s");/*time required to reach from A to B*/

Real v_avg[2](each unit="m/s");/*average velocity*/
Real v_C[2](each unit="m/s");/*instantaneous velocity*/
equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta);
s_mag=2*r;
s_x=s_mag*cos(theta_rad);
s_y=s_mag*sin(theta_rad);
s={s_x,s_y};

ACB=(2*pi*r)/2;
t=ACB/v_uniform;
v_avg=s/t;
v_C={v_uniform*cos(theta_rad),v_uniform*sin(theta_rad)};
end Ex2_3;
