class Ex3_14
parameter Real pi = Modelica.Constants.pi;

parameter Real G(unit="m^3.kg^(-1).s^(-2)")=6.67*10^(-11);/*constant of the universal gravitational*/
parameter Real m_E(unit="kg")=5.97*10^24;/*mass of the earth*/
parameter Real r_E(unit="m")=6.378*10^3*10^3;/*radius of the earth*/ 
parameter Real h(unit="m")=300*10^3;/*altitude of the satellite from the earth surface*/

Real r(unit="m");/*distance of the satellite from the center of the earth*/
Real T(unit="s");/*period of the satellite*/
equation
r=r_E+h;
T=(2*pi*r*sqrt(r))/sqrt(G*m_E);
/*the given answer of T in second is wrong*/
end Ex3_14;
