class Ex3_18
/*1 solar mass=2*10^30 kg*/
parameter Real pi = Modelica.Constants.pi;

parameter Real G(unit="m^3.kg^(-1).s^(-2)")=6.67*10^(-11);/*constant of the universal gravitational*/
parameter Real r(unit="m")=25000*10^16;/*distance between center of the galaxy and sun*/ 
parameter Real v(unit="m/s")=250*10^3;/*orbital speed of the sun*/

Real m_G(unit="kg");/*mass of the galaxy in kg*/
Real m_G_SM(unit="solar mass");/*mass of the galaxy in solar mass*/
equation
m_G=(v^2*r)/G;
m_G_SM=m_G/(2*10^30);
end Ex3_18;
