class Ex3_7
parameter Real pi = Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real mu=0.3;/*coefficient of friction between rope and cylinderical surfaces of the pins*/
parameter Real m(unit="kg")=100;/*total mass of the system*/
parameter Real T3(unit="N")=100;/*applied force at end A*/

Real T1(unit="N");/*tension in the tight side of the pin B*/
Real T2(unit="N");/*tension in the slack side of the pin B*/
Real a(unit="m/s^2");/*acceleration of the system*/
equation
T1/T2=exp(mu*pi);
T2/T3=exp(mu*pi);
m*a=m*g-T1+T3;
end Ex3_7;
