class Ex4_7
parameter Real G(unit="m^3.kg^(-1).s^(-2)")=6.67*10^(-11);/*constant of the universal gravitational*/
parameter Real m_M(unit="kg")=0.0716*10^24;/*mass of the moon*/
parameter Real r_M(unit="m")=1.74*10^6;/*radius of the moon*/

Real v_e_mps(unit="m/s");/*escape velocity from the surface of moon in m/s*/
Real v_e(unit="km/s");/*escape velocity from the surface of moon in km/s*/
equation
v_e_mps=sqrt((2*G*m_M)/r_M);
v_e=v_e_mps/1000;
/*The  answer may slightly vary due to  rounding off values*/
end Ex4_7;
