class Ex7_9
parameter Real pi = Modelica.Constants.pi;

parameter Real m(unit="kg")=30;/*mass of the block*/
parameter Real k1(unit="N/m")=120/10^(-2);/*stifness of the spring 1*/
parameter Real k2(unit="N/m")=300/10^(-2);/*stiffness of the spring 2*/
parameter Real k3(unit="N/m")=250/10^(-2);/*stiffness of the spring 2*/
Real k_eq_das(unit="N/m");/*equivalent spring of stiffness for srings 1 and 2*/
Real k_eq(unit="N/m");/*overall equivalent spring of stiffness*/
Real w_n(unit="rad/s");/*natural circular frequency of the block*/ 
Real f_n(unit="Hz");/*frequency of oscillation*/
equation
k_eq_das=k1+k2;
1/k_eq=1/k_eq_das+1/k3;
w_n=sqrt(k_eq/m);
f_n=w_n/(2*pi);
end Ex7_9;
