class Ex2_10
parameter Real r_1o[2](each unit="m")={0,0};/*initial position of particle 1*/
Real r1[2](each unit="m");/*position vector of particle 1*/
parameter Real r_2o[2](each unit="m")={10,0};/*initial position of particle 2*/
Real r2[2](each unit="m");/*position vector of particle 2*/

parameter Real v_mag(unit="m/s")=3;/*magnitude of the velocity of the both particle*/
Real v1[2](each unit="m/s");/*velocity vector of the particle 1*/
Real v2[2](each unit="m/s");/*velocity vector of the particle 2*/

parameter Real theta_deg(unit="deg")=45;/*angle between direction of velocity of particle 1 and x-axis in degree unit*/
Real theta_rad(unit="rad");/*angle between direction of velocity of particle 1 and x-axis in radian unit*/
Real d[2](each unit="m");/*relative position of particle 1 w.r.t particle 2*/
Real d_mag(unit="m");/*distance between two particle*/

equation
theta_rad=Modelica.SIunits.Conversions.from_deg(theta_deg);
v1={v_mag*cos(theta_rad),v_mag*sin(theta_rad)};
v2={0,v_mag};
r1=v1*time+r_1o;
r2=v2*time+r_2o;
d=r1-r2;
d_mag=Modelica.Math.Vectors.norm(d);
end Ex2_10;
