class Ex3_6
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_A(unit="kg")=20;/*mass of the block A*/
parameter Real m_B(unit="kg")=30;/*mass of the block B*/
parameter Real P(unit="N")=500;/*Applied force to block B*/
Real T(unit="N");/*tension in the rope*/
Real N2(unit="N");/*contact force between A and B*/
Real N3(unit="N");/*contact force between B and floor*/
Real f1(unit="N");/*friction force between A and B*/
Real f2(unit="N");/*friction force between B and floor*/
parameter Real mu1=0.3;/*coefficient of friction between A and B*/
parameter Real mu2=0.2;/*coefficient of friction between B and floor*/
Real a(unit="m/s^2");/*acceleration of the block B*/
equation
m_A*g-N2=0;
m_B*g+N2-N3=0;
f1=mu1*N2;
f2=mu2*N3;

m_A*a=T-f1;
m_B*a=P-T-f1-f2;
end Ex3_6;
