class Ex3_8
parameter Real pi = Modelica.Constants.pi;
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/
parameter Real r(unit="m")=0.25*10^(-2);/*radius of the hail*/
parameter Real rho_hail(unit="kg/m^3")=(1/1000)/(10^(-2))^3;/*density of the hail*/
parameter Real C1(unit="kg.m^(-1).s^(-1)")=3.1*10^(-4);
Real m(unit="kg");/*mass of the hail*/
Real v_term(unit="m/s");/*terminal velocity of the hail*/
equation
m=((4*pi)/3)*r^3*rho_hail;
v_term=(m*g)/(C1*r);
end Ex3_8;
