class Ex6_3
parameter Real g(unit="m/s^2")=9.81;/*acceleration due to gravity*/

parameter Real m_b(unit="kg")=20;/*mass of the hanging block*/
parameter Real m_p(unit="kg")=30;/*mass of the pully*/
parameter Real r(unit="m")=10/100;/*radius of the pully*/
parameter Real I(unit="kg.m^2")=0.2;/*moment of inertia of the pully*/

Real a(unit="m/s^2");/*acceleration of the hanging mass*/
Real alpha(unit="rad/s^2");/*angular acceleration of the pully*/
Real T(unit="N");/*tension in the string*/
Real R(unit="N");/*reaction in the hinge*/

parameter Real h(unit="m")=20/100;/*distance between initial and final positon of the hanging mass*/
Real w(unit="rad/s");/*angular velocity of the pully*/
Real v(unit="m/s",start=0.01);/*velocity of the mass at 20 cm height*/
equation
I*alpha=T*r;
m_b*a=m_b*g-T;
a=alpha*r;
R=m_p*g+T;

m_b*g*h=(1/2)*I*w^2+(1/2)*m_b*v^2;
v=w*r;
end Ex6_3;
