class Ex7_13
parameter Real pi = Modelica.Constants.pi;
parameter Real m(unit="kg")=15;/*mass of the system*/
parameter Real k(unit="N/m")=100/10^(-2);/*stiffness of the spring*/
parameter Real zeta=0.25;/*damping factor*/
Real w_n(unit="rad/s");/*natural circular frequency of the system*/ 
Real w_d(unit="rad/s");/*damped natural frequency of the system*/
Real T(unit="s");/*time period of the oscillation*/
equation
w_n=sqrt(k/m);
w_d=w_n*sqrt(1-zeta^2);
T=(2*pi)/w_d; 
end Ex7_13;
