class Ex7_15
parameter Real m(unit="kg")=8;/*mass of the system*/
parameter Real k(unit="N/m")=80/10^(-2);/*stiffness of the spring*/
parameter Real zeta=0.15;/*damping factor*/
parameter Real F_0(unit="N")=10;/*magnitude of the excitation force*/
parameter Real w(unit="rad")=28;/*frequency of the excitation force*/
Real w_n(unit="rad/s");/*natural frequency of the system*/
Real r;/*frequency ratio*/
Real M;/*magnification factor*/
Real delta(unit="m");/*static deflection*/
Real X(unit="m");/*amplitude of the oscillation*/
Real phi_rad(unit="rad");/*phase difference in radian unit*/
Real phi(unit="deg");/*phase difference in degree unit*/
equation
w_n=sqrt(k/m);
r=w/w_n;
M=1/sqrt((1-r^2)^2+(2*zeta*r)^2);
delta=F_0/k;
X=delta/sqrt((1-r^2)^2+(2*zeta*r)^2);
tan(phi_rad)=(2*zeta*r)/(1-r^2);
phi=Modelica.SIunits.Conversions.to_deg(phi_rad);
/*The  answer may slightly vary due to  rounding off values*/
end Ex7_15;
