class Ex7_16
parameter Real m_e(unit="kg")=6*10^24;/*mass of the earth*/
parameter Real R(unit="m")=6378*10^3;/*radius of the earth*/
parameter Real G(unit="m3.kg^(-1).s^(-2)")=6.67*10^(-11);/*gravitational constant*/
 
parameter Real m_s(unit="kg")=750;/*mass of the satellite*/
parameter Real h_min(unit="m")=250*10^3;/*minimum altitude from the earth surface*/
parameter Real h_max(unit="m")=1500*10^3;/*maximum altitude from the earth surface*/

Real r_min(unit="m");/*minimum distance from the center of earth*/
Real r_max(unit="m");/*maximum distance from the center of earth*/
Real a(unit="m");/*semi major axis of the orbit*/
Real E(unit="J");/*energy of the satellite*/
equation
r_min=R+h_min;
r_max=R+h_max;
a=(1/2)*(r_min+r_max);
E=-(G*m_e*m_s)/(2*a);
/*The  answer provided in the textbook is wrong*/
end Ex7_16;
